import edu.princeton.cs.algs4.Point2D;
import edu.princeton.cs.algs4.StdRandom;

public class Circle implements Shape {
    private static final double PI = 3.14159265;
    private double radius;
    private Point2D position;

    public Circle(double r) {
        radius = r;
        position = new Point2D(StdRandom.uniform(), StdRandom.uniform());
    }

    public double getRadius() {
        return radius;
    }

    @Override
    public Point2D getPosition() {
        return position;
    }

    @Override
    public void setPosition(Point2D pos) {
        position = pos;
    }

    @Override
    public double getArea() {
        return radius * radius * PI;
    }

    static double computeArea(double r) {
        return r * r * PI;
    }
}