import edu.princeton.cs.algs4.Point2D;
import edu.princeton.cs.algs4.StdRandom;

class Rectangle implements Polygon {
    // instance variables
    private double width;
    private double height;
    private Point2D position;

    // constructor
    Rectangle(double w, double h) {
        width = w;
        height = h;
        position = new Point2D(StdRandom.uniform(), StdRandom.uniform());
    }

    public double getWidth() {
        return width;
    }

    public double getHeight() {
        return height;
    }

    @Override
    public Point2D getPosition() {
        return position;
    }

    @Override
    public void setPosition(Point2D pos) {
        position = pos;
    }

    public double getArea() {
        return width * height;
    }

    @Override
    public Point2D[] getVertexes() {
        Point2D[] verts = new Point2D[4];
        // clockwise starting with upper left
        verts[0] = new Point2D(position.x() - width / 2, position.y() - height / 2);
        verts[1] = new Point2D(position.x() + width / 2, position.y() - height / 2);
        verts[2] = new Point2D(position.x() + width / 2, position.y() + height / 2);
        verts[3] = new Point2D(position.x() - width / 2, position.y() + height / 2);
        return verts;
    }
}